import React from 'react';
import { Link, useNavigate } from 'react-router-dom';
import { 
  FiHome, 
  FiUser, 
  FiCode, 
  FiSearch, 
  FiStar, 
  FiLogOut,
  FiLogIn,
  FiUserPlus,
  FiTarget
} from 'react-icons/fi';

const Navbar: React.FC = () => {
  const user = localStorage.getItem('user') ? JSON.parse(localStorage.getItem('user')!) : null;
  const navigate = useNavigate();

  const handleLogout = () => {
    localStorage.removeItem('user');
    localStorage.removeItem('token');
    navigate('/login');
  };

  return (
    <nav className="bg-white/95 backdrop-blur-sm shadow-md border-b border-gray-100 py-3 px-6 flex items-center justify-between sticky top-0 z-50">
      <div className="flex items-center space-x-8">
        <Link to={user ? '/dashboard' : '/'} className="flex items-center space-x-2">
          <div className="w-8 h-8 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
            <FiTarget className="text-white text-lg" />
          </div>
          <span className="text-xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
            PopCareers
          </span>
        </Link>
        
        {user && user.role === 'student' && (
          <div className="flex items-center space-x-6">
            <Link to="/student-dashboard" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiHome size={16} />
              <span>Dashboard</span>
            </Link>
            <Link to="/profile" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiUser size={16} />
              <span>Profile</span>
            </Link>
            <Link to="/my-card" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiCode size={16} />
              <span>My Card</span>
            </Link>
          </div>
        )}
        
        {user && user.role === 'recruiter' && (
          <div className="flex items-center space-x-6">
            <Link to="/recruiter-dashboard" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiHome size={16} />
              <span>Dashboard</span>
            </Link>
            <Link to="/scanner" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiSearch size={16} />
              <span>Scanner</span>
            </Link>
            <Link to="/shortlist" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiStar size={16} />
              <span>Shortlist</span>
            </Link>
            <Link to="/profile" className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium">
              <FiUser size={16} />
              <span>Profile</span>
            </Link>
          </div>
        )}
      </div>
      
      <div className="flex items-center space-x-3">
        {user ? (
          <div className="flex items-center space-x-3">
            <div className="flex items-center space-x-2 px-3 py-1.5 bg-gray-50 rounded-lg">
              <div className="w-6 h-6 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center">
                <FiUser className="text-white text-xs" />
              </div>
              <span className="text-sm font-medium text-gray-700">{user.name || user.email}</span>
            </div>
            <button 
              onClick={handleLogout} 
              className="flex items-center space-x-1 bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-2 rounded-lg hover:from-blue-700 hover:to-purple-700 transition-all duration-200 font-medium"
            >
              <FiLogOut size={16} />
              <span>Logout</span>
            </button>
          </div>
        ) : (
          <div className="flex items-center space-x-3">
            <Link 
              to="/login" 
              className="flex items-center space-x-1 text-gray-700 hover:text-blue-600 transition-colors font-medium"
            >
              <FiLogIn size={16} />
              <span>Login</span>
            </Link>
            <Link 
              to="/register" 
              className="flex items-center space-x-1 bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-2 rounded-lg hover:from-blue-700 hover:to-purple-700 transition-all duration-200 font-medium"
            >
              <FiUserPlus size={16} />
              <span>Register</span>
            </Link>
          </div>
        )}
      </div>
    </nav>
  );
};

export default Navbar; 