import requests
import os

# Replace with your Groq API key
API_KEY = os.getenv("GROQ_API_KEY", "your-groq-api-key-here")

url = "https://api.groq.com/openai/v1/chat/completions"

headers = {
    "Content-Type": "application/json",
    "Authorization": f"Bearer {API_KEY}"
}

data = {
    "messages": [
        {
            "role": "user",
            "content": "Explain how AI works in a few words"
        }
    ],
    "model": "llama-3.3-70b-versatile",
    "stream": False,
    "temperature": 0
}

response = requests.post(url, headers=headers, json=data)

if response.status_code == 200:
    print("API key is valid!")
    print(response.json())
else:
    print("API key test failed!")
    print(response.status_code, response.text)
