<?php

require_once 'vendor/autoload.php';

use App\Models\User;
use Illuminate\Support\Facades\Hash;

// Initialize Laravel
$app = require_once 'bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // Find an existing user
    $user = User::where('email', 'student@example.com')->first();
    
    if ($user) {
        echo "✅ User found: " . $user->email . "\n";
        
        // Test createToken method
        $token = $user->createToken('Test Token');
        echo "✅ Token created: " . $token->plainTextToken . "\n";
        
        echo "✅ Sanctum token generation is working!\n";
    } else {
        echo "❌ No user found to test with\n";
    }

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "❌ Check if Laravel Sanctum is properly configured\n";
}
