<?php

require __DIR__ . '/vendor/autoload.php';
$app = require __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\AISkillNormalizer;

$skills = [
    'Solidity',
    'Next.js',
    'Terraform',
    'FastAPI',
    'SvelteKit',
];

foreach ($skills as $skill) {
    echo "Normalizing: $skill\n";
    $result = AISkillNormalizer::normalizeWithGroq($skill);
    if ($result) {
        echo " -> Canonical: " . ($result['canonical_name'] ?? 'N/A') . "\n";
        echo " -> Category: " . ($result['category'] ?? 'N/A') . "\n";
        echo " -> Confidence: " . ($result['confidence'] ?? 'N/A') . "\n";
    } else {
        echo " -> No AI result (check logs)\n";
    }
}
