<?php

require __DIR__ . '/vendor/autoload.php';
// Bootstrap Laravel to use facades and env()
$app = require __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

// Test Groq API
$apiKey = config('services.groq.key');
if (!$apiKey) {
    echo "GROQ_API_KEY not configured (config services.groq.key)\n";
    exit(1);
}
echo "Testing Groq API (key prefix): " . substr($apiKey, 0, 6) . "***\n";

$response = Http::withOptions(['verify' => false])->withHeaders([
    'Content-Type' => 'application/json',
    'Authorization' => 'Bearer ' . $apiKey,
])->post('https://api.groq.com/openai/v1/chat/completions', [
    'messages' => [
        [
            'role' => 'system',
            'content' => 'Respond ONLY with valid JSON.'
        ],
        [
            'role' => 'user',
            'content' => '{"ping": "pong"}'
        ]
    ],
    'model' => 'llama-3.3-70b-versatile',
    'stream' => false,
    'temperature' => 0
]);

echo "Response Status: " . $response->status() . "\n";
echo "Response Body: " . $response->body() . "\n";

if ($response->successful()) {
    $json = $response->json();
    if (isset($json['choices'][0]['message']['content'])) {
        echo "AI Response: " . $json['choices'][0]['message']['content'] . "\n";
    }
} else {
    echo "API call failed\n";
}
