<?php

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

// Test Grok API
$apiKey = env('GROK_API_KEY');
echo "Testing Grok API with key: " . substr($apiKey, 0, 10) . "...\n";

$response = Http::withHeaders([
    'Content-Type' => 'application/json',
    'Authorization' => 'Bearer ' . $apiKey,
])->post('https://api.x.ai/v1/chat/completions', [
    'messages' => [
        [
            'role' => 'user',
            'content' => 'Hello, please respond with a simple JSON object: {"test": "success"}'
        ]
    ],
    'model' => 'grok-beta',
    'stream' => false,
    'temperature' => 0
]);

echo "Response Status: " . $response->status() . "\n";
echo "Response Body: " . $response->body() . "\n";

if ($response->successful()) {
    $json = $response->json();
    if (isset($json['choices'][0]['message']['content'])) {
        echo "AI Response: " . $json['choices'][0]['message']['content'] . "\n";
    }
} else {
    echo "API call failed\n";
}
