<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';

// Test the slug generation
$raw = 'Java Script';
$slug = strtolower(preg_replace('/\s+/', ' ', str_replace(['.', '_', '-'], ' ', trim($raw))));

echo "✅ Slug generation working\n";
echo "Input: '$raw'\n";
echo "Slug: '$slug'\n\n";

// Test database access
try {
    $count = \App\Models\SkillNormalization::count();
    echo "✅ Database connection working\n";
    echo "Skills in database: $count\n\n";
    
    // Test the controller
    echo "✅ All systems ready for API request\n";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
