<?php

require_once 'vendor/autoload.php';

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

// Initialize Laravel
$app = require_once 'bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // Test creating a student user
    $user = new User();
    $user->email = 'student@example.com';
    $user->password = Hash::make('password123');
    $user->role = 'student';
    $user->save();

    echo "✅ Student user created successfully with ID: " . $user->id . "\n";

    // Test creating a recruiter user
    $recruiter = new User();
    $recruiter->email = 'recruiter@example.com';
    $recruiter->password = Hash::make('password123');
    $recruiter->role = 'recruiter';
    $recruiter->save();

    echo "✅ Recruiter user created successfully with ID: " . $recruiter->id . "\n";

    // Test authentication
    $auth = Auth::attempt(['email' => 'student@example.com', 'password' => 'password123']);
    echo "🔐 Authentication test: " . ($auth ? "SUCCESS" : "FAILED") . "\n";

    echo "✅ All tests passed! Schema supports user registration and login.\n";

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
