<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Test database connection
Route::get('/test-db', function () {
    try {
        DB::connection()->getDatabaseName();
        $result = DB::select('SELECT version()');
        
        return response()->json([
            'status' => 'success',
            'message' => 'PostgreSQL connected successfully!',
            'database' => config('database.default'),
            'host' => config('database.connections.pgsql.host'),
            'database_name' => config('database.connections.pgsql.database'),
            'version' => $result[0]->version ?? 'Unknown'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Database connection failed',
            'error' => $e->getMessage()
        ], 500);
    }
});

Route::get('/login', function () {
    return view('auth.login'); // You can customize this view
})->name('login');

