<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSkillNormalizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skill_normalizations', function (Blueprint $table) {
            $table->id();
            $table->string('canonical_name')->unique()->index();
            $table->json('aliases')->nullable(); // Store as JSON array
            $table->string('category')->nullable(); // e.g., 'Language', 'Framework', 'Tool', 'Skill'
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('skill_normalizations');
    }
}
