<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddCompanyNameToRecruitersTable extends Migration
{
    public function up()
    {
        // Add a denormalized company_name column to recruiters for convenience
        DB::statement("ALTER TABLE recruiters ADD COLUMN company_name VARCHAR(255);");
    }

    public function down()
    {
        Schema::table('recruiters', function (Blueprint $table) {
            if (Schema::hasColumn('recruiters', 'company_name')) $table->dropColumn('company_name');
        });
    }
}
