<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateShortlistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('
            CREATE TABLE shortlists (
                id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
                recruiter_id UUID REFERENCES recruiters(user_id),
                student_id UUID REFERENCES students(user_id),
                private_note TEXT,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )
        ');
        
        DB::statement('CREATE INDEX idx_shortlists_recruiter_id ON shortlists(recruiter_id)');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('DROP INDEX IF EXISTS idx_shortlists_recruiter_id');
        Schema::dropIfExists('shortlists');
    }
}
