<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('
            CREATE TABLE students (
                user_id UUID PRIMARY KEY REFERENCES users(id) ON DELETE CASCADE,
                full_name VARCHAR(255) NOT NULL,
                phone VARCHAR(50),
                linkedin VARCHAR(255),
                github VARCHAR(255),
                university VARCHAR(255),
                graduation_year VARCHAR(50),
                languages JSONB,
                summary TEXT,
                cv_file_url VARCHAR(500),
                qr_code_url VARCHAR(500),
                is_card_active BOOLEAN DEFAULT TRUE,
                photo_url VARCHAR(500)
            )
        ');
        
        DB::statement('CREATE INDEX idx_students_is_card_active ON students(is_card_active)');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('DROP INDEX IF EXISTS idx_students_is_card_active');
        DB::statement('DROP TABLE IF EXISTS students');
    }
}
