<?php

namespace App\Policies;

use App\Models\Education;
use App\Models\User;

class EducationPolicy
{
    public function viewAny(User $user, $student_id)
    {
        // Student can view their own educations, others might be allowed too (recruiters, etc.)
        return $user->isStudent() && $user->id === $student_id;
    }

    public function view(User $user, Education $education)
    {
        // Any authenticated user can view
        return true;
    }

    public function create(User $user, $student_id)
    {
        // Only the student themselves can create for their profile
        return $user->isStudent() && $user->id === $student_id;
    }

    public function update(User $user, Education $education)
    {
        // Only the owner student can update
        return $user->isStudent() && $user->id === $education->student_id;
    }

    public function delete(User $user, Education $education)
    {
        // Only the owner student can delete
        return $user->isStudent() && $user->id === $education->student_id;
        return $user->isStudent() && $user->student && $user->student->user_id === $education->student_id;
    }
} 