<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Shortlist extends Model
{
    public $incrementing = false;
    protected $keyType = 'string';
    protected $table = 'shortlists';
    protected $fillable = [
        'id', 'recruiter_id', 'student_id', 'private_note', 'created_at'
    ];
    public $timestamps = false;

    public function recruiter(): BelongsTo
    {
        return $this->belongsTo(Recruiter::class, 'recruiter_id', 'user_id');
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'user_id');
    }
} 