<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        if ($request->expectsJson()) {
            abort(response()->json([
                'message' => 'Unauthenticated. You must be logged in as a recruiter to view this profile.'
            ], 401));
        }
        abort(403, 'You must be logged in as a recruiter to view this profile.');
    }
}
